export default ({ app, store }) => {
  app.router.beforeEach(async (to, from, next) => {
    const isLogin = store.state.user.id || (await store.dispatch('checkLogin'))

    if (to.meta.requiredLogin && !isLogin) {
      location.href = `${process.env.loginURL}/login/index?redirect_uri=${encodeURIComponent(location.href)}`
      return
    }
    next()
  })
}
