import { STAGE_LIST } from '../../index'
export default function (_this) {
  return {
    required: true,
    id: 'interview_yynl',
    title: '语言能力证明',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { basic_info: basicInfo = {}, attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material

        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) > 2
        const attachment = attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'INTERNATIONAL_LANGUAGE_SCORE') {
              result.INTERNATIONAL_LANGUAGE_SCORE.push(item)
            }
            return result
          },
          { INTERNATIONAL_LANGUAGE_SCORE: [] }
        )
        return Object.assign({}, basicInfo, attachment)
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        const basicInfo = ['language_score'].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
      // callback() {
      //   _this.changeSubmissionStage(() => {
      //     this.form.options.disabled = true
      //   })
      // }
    },
    form: {
      prev: { to: { query: { active: 'interview_cjd' } }, isSubmit: true },
      next: { to: { query: { active: 'interview_tjx' } }, isSubmit: true },
      submitText: '保存',
      // hasSubmit: false,
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-input',
          label: '语言成绩(填写示例：大学英语六级/550)',
          model: 'language_score',
          attrs: { placeholder: '请填写您的语言成绩' },
          rules: [{ required: true, message: '请填写您的语言成绩', trigger: 'blur' }]
        },
        {
          required: true,
          type: 'v-upload',
          label: '语言成绩单',
          model: 'INTERNATIONAL_LANGUAGE_SCORE',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'INTERNATIONAL_LANGUAGE_SCORE' }
          },
          rules: [{ required: true, message: '请上传', trigger: 'change' }],
          append: '成绩单类型包括：CET-4，CET-6，TOEFL，IELTS等'
        }
      ]
    }
  }
}
