import path from 'path'
import fs from 'fs'
import routes from './router/routes'

let config = {}
if (process.env.NODE_ENV === 'production') {
  config = {
    env: {
      projectId: '1012',
      newProjectId: '9946887509442560',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth'
    },
    server: { port: 2048, host: '0.0.0.0' }
  }
} else {
  config = {
    env: {
      projectId: '1012',
      newProjectId: '9946887509442560',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth'
    },
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }
}

export default {
  ...config,
  ssr: false,
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '清控紫荆教育MBA官网_MBA培训_在职研究生_在职考研_免联考硕士学历提升机构',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      {
        hid: 'keywords',
        name: 'keywords',
        content: 'MBA培训，MBA报名，在职研究生，在职考研，免联考硕士，紫荆教育，清控紫荆教育，在职硕士，学历提升'
      },
      {
        hid: 'description',
        name: 'description',
        content:
          '清控紫荆教育MBA官网，为中高层管理者提供MBA培训_在职研究生_在职考研_免联考硕士学历提升服务，助力企业中高层提升认知，解决问题！'
      },
      { name: 'viewport', id: 'viewport', content: 'initial-scale=-1,maximum-scale=1,shrink-to-fit=no' }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    },
    {
      src: 'plugins/tongji.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: [],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes
  }
}
