export default function(_this) {
  return {
    required: true,
    id: 'interview_tjx',
    title: '推荐信',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${_this.$store.state.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            const types = ['RECOMMENDATION_LETTER', 'RECOMMENDATION_LETTER_2']
            types.forEach(type => {
              item.disabled = item.upload_operator_user_id !== _this.user?.id
              if (item.file_type_id === type) {
                result.RECOMMENDATION_LETTER.push(item)
              }
            })
            return result
          },
          { RECOMMENDATION_LETTER: [] }
        )
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${_this.$store.state.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_ywjl' } } },
      submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-upload',
          model: 'RECOMMENDATION_LETTER',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/delete`,
            data: { file_type: 'RECOMMENDATION_LETTER' },
            accept: 'image/*'
          },
          append: '请上传推荐人署名的推荐信原件照片或扫描件 ',
          class: 'upload-letter'
        }
      ]
    }
  }
}
