export default function(_this) {
  return {
    id: 'interview_ywjl',
    title: '英文简历',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const RESUME_EN = attachments.filter(item => {
          return item.file_type_id === 'RESUME_EN'
        })
        return { RESUME_EN }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_byzs' } } },
      submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: {},
      items: [
        {
          type: 'v-upload',
          model: 'RESUME_EN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RESUME_EN' }
          },
          append: `
        <p>请下载填写英文简历模板后上传 [<a href="https://webapp-pub.ezijing.com/project/marywood-plus/%E8%8B%B1%E6%96%87%E7%AE%80%E5%8E%86%E6%A8%A1%E6%9D%BF.docx" target="_blank" download="英文简历模板">下载模板</a>]</p>
        <p>请将英文简历填写完存为"pdf"格式上传，文件小于10MB。</p>`
        }
      ]
    }
  }
}
