/**
 * 个人信息
 */

export default function(_this) {
  return {
    id: 'application_info_cbu',
    title: 'CBU要求信息',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { basic_info: basicInfo = {}, submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'
        return Object.assign({}, basicInfo)
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        // let [province, city] = data.city.split('-')
        // data.address_province = province
        // data.address_city = city
        const basicInfo = [
          'faith',
          'marital_status',
          'identity_status',
          'have_studied',
          'have_crimed',
          'have_fired',
          'have_broke_the_rules'
        ].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_profile' } } },
      next: { to: { query: { active: 'application_info', tab: 'application_info_education' } }, isSubmit: true },
      options: {},
      items: [
        {
          type: 'v-select',
          label: '宗教信仰',
          model: 'faith',
          values: [
            { label: '无宗教信仰', value: '无宗教信仰' },
            { label: '基督教', value: '基督教' },
            { label: '天主教', value: '天主教' },
            { label: '佛教', value: '佛教' },
            { label: '伊斯兰教', value: '伊斯兰教' },
            { label: '道教', value: '道教' },
            { label: '其它', value: '其它' }
          ],
          attrs: { placeholder: '请选择', filterable: true },
          rules: [{ required: true, message: '请选择', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          label: '婚姻状况',
          model: 'marital_status',
          values: [
            { label: '单身', value: '单身' },
            { label: '已婚', value: '已婚' },
            { label: '离异', value: '离异' },
            { label: '丧偶', value: '丧偶' },
            { label: '分居', value: '分居' }
          ],
          attrs: { placeholder: '请选择', filterable: true },
          rules: [{ required: true, message: '请选择', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          label: '身份状况',
          model: 'identity_status',
          values: [
            { label: '美国公民', value: '美国公民' },
            { label: '永久居民', value: '永久居民' },
            { label: '非美国公民/非永久居民', value: '非美国公民/非永久居民' }
          ],
          attrs: { placeholder: '请选择', filterable: true },
          rules: [{ required: true, message: '请选择', trigger: 'blur' }]
        },
        {
          type: 'v-radio',
          values: [
            { label: '是', value: '1' },
            { label: '否', value: '0' }
          ],
          label: '您之前是否在CBU学习过',
          model: 'have_studied',
          rules: [{ required: true, message: '请选择', trigger: 'change' }]
        },
        {
          type: 'v-radio',
          values: [
            { label: '是', value: '1' },
            { label: '否', value: '0' }
          ],
          label: '您之前是否有过犯罪记录(不包括轻微的交通违规行为)，或者目前有任何指控待决',
          model: 'have_crimed',
          rules: [{ required: true, message: '请选择', trigger: 'change' }]
        },
        {
          type: 'v-radio',
          values: [
            { label: '是', value: '1' },
            { label: '否', value: '0' }
          ],
          label: '您是否曾经被学术解雇，被宣布没有资格参加，或在任何机构受到纪律处分，或者是否有任何案件正在审理中？',
          model: 'have_fired',
          rules: [{ required: true, message: '请选择', trigger: 'change' }]
        },
        {
          type: 'v-radio',
          values: [
            { label: '是', value: '1' },
            { label: '否', value: '0' }
          ],
          label: '您是否曾经因违反学生手册或荣誉守则政策而被定罪，或者目前有任何案件悬而未决？',
          model: 'have_broke_the_rules',
          rules: [{ required: true, message: '请选择', trigger: 'change' }]
        }
      ]
    }
  }
}
