export default function(_this) {
  return {
    id: 'admission_yynl',
    title: '语言能力证明',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'DOMESTIC_LANGUAGE_SCORE') {
              result.DOMESTIC_LANGUAGE_SCORE.push(item)
            }
            if (item.file_type_id === 'INTERNATIONAL_LANGUAGE_SCORE') {
              result.INTERNATIONAL_LANGUAGE_SCORE.push(item)
            }
            return result
          },
          { DOMESTIC_LANGUAGE_SCORE: [], INTERNATIONAL_LANGUAGE_SCORE: [] }
        )
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_cjd' } } },
      next: { to: { query: { active: 'admission_xy' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-upload',
          label: '国内语言成绩',
          model: 'DOMESTIC_LANGUAGE_SCORE',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DOMESTIC_LANGUAGE_SCORE' }
          },
          append: `<p>有大学英语四级或六级成绩，请上传凭证</p>`
        },
        {
          type: 'v-upload',
          label: '国际语言成绩',
          model: 'INTERNATIONAL_LANGUAGE_SCORE',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'INTERNATIONAL_LANGUAGE_SCORE' }
          },
          append: `<p>有托福，雅思，GMAT，GRE或其他考试成绩，请上传凭证</p>`
        }
      ]
    }
  }
}
