/**
 * 推荐信
 */

export default function(_this) {
  return {
    id: 'application_tjx',
    title: '推荐信',
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 3
        const list = data.data.material.reco_letters || []
        return list.length ? list : [{}, {}, {}]
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        // const recoLetters = data.map(item => {
        //   return ['provider_name', 'provider_phone_number', 'provider_email', 'provider_relationship'].reduce(
        //     (result, key) => {
        //       result[key] = item[key]
        //       return result
        //     },
        //     {}
        //   )
        // })
        return { reco_letters: data }
      }
    },
    form: {
      minlength: 3,
      prev: { to: { query: { active: 'application_info', tab: 'application_info_honor' } }, isSubmit: true },
      next: { to: { query: { active: 'application_wfzzm' } }, isSubmit: true },
      hasAdd: true,
      disabled(data) {
        return !!data.letter_content
      },
      aside: {
        prepend: {
          html: '<p style="color:#33C011;">推荐人已完成</p>',
          visible(data) {
            return !!data.letter_content
          }
        },
        buttons: [
          {
            text: '再次邀请',
            visible(data) {
              const editable = ['PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION'].includes(
                _this.detail.material.submission_stage
              )
              return data.id && !data.letter_content && editable
            },
            onClick(data) {
              _this.sendToProvider(data)
            }
          },
          {
            text: '更换推荐人',
            visible(data) {
              const editable = ['PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION'].includes(
                _this.detail.material.submission_stage
              )
              return data.id && !data.letter_content && editable
            },
            onClick(data, $form) {
              $form.validate().then(() => {
                _this.changeProvider(data)
              })
            }
          }
        ]
      },
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-input',
          label: '推荐人姓名',
          model: 'provider_name',
          attrs: { placeholder: '请输入推荐人姓名' },
          rules: [{ required: true, message: '请输入推荐人姓名', trigger: 'blur' }]
        },

        {
          type: 'v-input',
          label: '推荐人电话',
          model: 'provider_phone_number',
          attrs: { placeholder: '请输入推荐人电话', maxlength: 11 },
          rules: [{ required: true, pattern: /^1[3-9]\d{9}$/, message: '请输入推荐人电话', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '推荐人邮箱',
          model: 'provider_email',
          attrs: { placeholder: '请输入推荐人邮箱' },
          rules: [{ type: 'email', required: true, message: '请输入推荐人邮箱', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [
            { value: '老师/导师' },
            { value: '领导' },
            { value: '同学' },
            { value: '同事' },
            { value: '亲属' },
            { value: '朋友' },
            { value: '其他' }
          ],
          label: '与推荐人关系',
          model: 'provider_relationship',
          rules: [{ required: true, message: '请选择与推荐人关系', trigger: 'change' }]
        }
      ]
    }
  }
}
