export default ({ app, store }) => {
  let isSetProjectId = false
  app.router.beforeEach(async (to, from, next) => {
    const isLogin = store.state.user.id || (await store.dispatch('checkLogin'))

    if (to.meta.requiredLogin && !isLogin) {
      location.href = `${process.env.loginURL}/login/index?redirect_uri=${encodeURIComponent(location.href)}`
      return
    }
    if (location.hostname.includes('marywood-mis')) {
      store.commit('setProjectId', 1022)
    }
    if (to.path.includes('/my') && !isSetProjectId) {
      await store.dispatch('setProjectId')
      isSetProjectId = true
      if (to.path !== '/my/account' && !store.state.projectId) {
        next('/my/account')
        return
      }
    }
    next()
  })
}
