export default function (_this) {
  return {
    required: true,
    id: 'interview_grcs',
    title: '个人陈述',
    get: {
      callback(data) {
        const { attachments = [] } = _this.detail.material
        const PERSONAL_STATEMENT = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_STATEMENT'
        })
        return { PERSONAL_STATEMENT }
      }
    },
    form: {
      hasSubmit: false,
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'PERSONAL_STATEMENT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_STATEMENT' },
            limit: 1
          },
          append: '请上传您的个人陈述（英文）'
        }
      ]
    }
  }
}
