import path from 'path'
import fs from 'fs'
import routes from './router/routes'

let config = {}
if (process.env.NODE_ENV === 'production') {
  config = {
    env: {
      projectId: '1012',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth'
    },
    server: { port: 2048, host: '0.0.0.0' }
  }
} else {
  config = {
    env: {
      projectId: '1012',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth'
    },
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }
}

export default {
  ...config,
  ssr: false,
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '玛丽伍德MBA硕士学位-在线MBA课程-清华控股旗下在线教育品牌',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      // { hid: 'description', name: 'description', content: '' },
      {
        name: 'keywords',
        content:
          '工商管理硕士，MBA硕士，免联考MBA，国际MBA，通用MBA，在职MBA，在线MBA，MBA'
      },
      {
        name: 'description',
        content:
          '美国玛丽伍德大学（Marywood University）创办于 1915 年，有超过100年的历史。学校位于斯克兰顿市，宾夕法尼亚州，占地700亩。学校地理位置优越，距离美国金融中心纽约和美国最古老城市之一的费城均约2.5小时车程。玛丽伍德大学是一所拥有128名全职教授、超过 3,000 名在校学生的综合性大学，大学设置超过100个本科、硕士及博士专业'
      },
      { name: 'viewport', id: 'viewport', content: 'initial-scale=-1,maximum-scale=1,shrink-to-fit=no' }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: [],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes
  }
}
