import { STAGE_LIST } from '../../index'
export default function (_this) {
  return {
    required: true,
    id: 'interview_cjd',
    title: '成绩单',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { basic_info: basicInfo = {}, attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material

        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) > 2
        const attachment = attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'REPORT_CARD_CN') {
              result.REPORT_CARD_CN.push(item)
            }
            if (item.file_type_id === 'REPORT_CARD_EN') {
              result.REPORT_CARD_EN.push(item)
            }
            return result
          },
          { REPORT_CARD_CN: [], REPORT_CARD_EN: [] }
        )
        return Object.assign({}, basicInfo, attachment)
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        const basicInfo = ['gpa_score', 'average_score'].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_ywjl' } }, isSubmit: true },
      next: { to: { query: { active: 'interview_yynl' } }, isSubmit: true },
      submitText: '保存',
      // hasSubmit: false,
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-input',
          label: 'GPA成绩 (填写示例：3.9 / 5.0)',
          model: 'gpa_score',
          attrs: { placeholder: '请填写您的GPA成绩' },
          rules: [{ required: true, message: '请填写您的GPA成绩', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '百分制平均成绩',
          model: 'average_score',
          attrs: { placeholder: '请填写百分制平均成绩' },
          rules: [{ required: true, message: '请填写百分制平均成绩', trigger: 'blur' }]
        },
        {
          required: true,
          type: 'v-upload',
          label: '中文成绩单',
          model: 'REPORT_CARD_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'REPORT_CARD_CN' }
          }
        },
        {
          required: true,
          type: 'v-upload',
          label: '英文成绩单',
          model: 'REPORT_CARD_EN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'REPORT_CARD_EN' }
          },
          append: `
          <p>已毕业学生需提交完整成绩单，未毕业学生提交现有成绩单，成绩单需要加盖学校公章</p>
          <p>请将成绩单原件扫描或者拍照后提交。</p>
          <p>获取途径:联系大学时就读学校相关部门(档案馆/教务处)获取成绩单。</p>`
        }
      ]
    }
  }
}
