export default function(_this) {
  return {
    required: true,
    id: 'admission_xfjn',
    title: '缴费凭证',
    // visible() {
    //   return _this.hasPay
    // },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'REGISTRATION',
          'PAYMENT',
          'CLOSED'
        ]
        // this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const PAYMENT_VOUCHER = attachments.filter(item => {
          return item.file_type_id === 'PAYMENT_VOUCHER'
        })
        return { PAYMENT_VOUCHER }
      }
    },
    form: {
      next: { to: { query: { active: 'admission_xy' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      // hint: `
      //   <p><strong>一、对公收款银行信息：</strong></p>
      //   <p>户名：清控紫荆（ 北京）教育科技股份有限公司</p>
      //   <p>帐号：694485289</p>
      //   <p>开户行：中国民生银行股份有限公司北京魏公村支行</p>
      //   <p style="margin-top:30px;"><strong>二、支付宝收款账户信息：</strong></p>
      //   <p>支付宝账号：service@ezijing.com</p>
      //   <p>支付宝户名：清控紫荆（北京）教育科技股份有限公司</p>`,
      items: [
        {
          required: true,
          type: 'v-upload',
          model: 'PAYMENT_VOUCHER',
          label: '上传缴费凭证',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PAYMENT_VOUCHER' }
          },
          append: `申请者可将转账/支付缴费凭证截图或拍照后提交。<br>
          上传多个文件，请打印出来检查无误后再上传。用A4纸打印后内容需显示完整、格式整齐、字迹清晰可辨。上传文件仅限“jpg,jpeg,pdf,png”格式，文件小于10Mb。`
        }
      ]
    }
  }
}
