export default function(_this) {
  return {
    required: true,
    id: 'admission_byzs',
    title: '毕业证书或在读证明',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const {
          basic_info: basicInfo = {},
          attachments = [],
          submission_stage: submissionStage = 'FILLING'
        } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'REGISTRATION',
          'PAYMENT',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) >= 6
        const attachment = attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'DIPLOMA_CN') {
              result.DIPLOMA_CN.push(item)
            }
            if (item.file_type_id === 'DEGREE_CERT_CN') {
              result.DEGREE_CERT_CN.push(item)
            }
            if (item.file_type_id === 'PROOF_READING') {
              result.PROOF_READING.push(item)
            }
            return result
          },
          { DIPLOMA_CN: [], DEGREE_CERT_CN: [], PROOF_READING: [] }
        )
        return Object.assign({ learn_status: basicInfo.learn_status }, attachment)
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        const basicInfo = ['learn_status'].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      },
      callback() {
        _this.changeSubmissionStage(() => {
          this.form.options.disabled = true
          // _this.$router.push('/my/admission')
        })
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_grcs' } } },
      submitText: '提交申请',
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-select',
          values: [{ value: '已毕业' }, { value: '未毕业' }],
          label: '您当前的学习状态',
          model: 'learn_status',
          rules: [{ required: true, message: '请选择', trigger: 'change' }],
          append: `
          提示：<br />
          1、请同时上传毕业证书及学位证书（中英文）<br />
          2、如尚未毕业，请上传在读证明（中英文）`
        },
        {
          required: true,
          label: '毕业证书',
          type: 'v-upload',
          model: 'DIPLOMA_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DIPLOMA_CN' }
          },
          rules: { required: true, message: '请上传毕业证书' },
          append:
            '申请者需要将本科或以上毕业证书原件扫描或者拍照后提交。<br> 可上传多个文件，请确保证书号码清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。',
          isShow(ruleForm) {
            return ruleForm.learn_status === '已毕业'
          }
        },
        {
          required: true,
          label: '学位证书',
          type: 'v-upload',
          model: 'DEGREE_CERT_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DEGREE_CERT_CN' }
          },
          rules: { required: true, message: '请上传学位证书' },
          append:
            '已毕业学员请提交学位证书<br />申请者需要将本科或以上的学位证书原件扫描或拍照后提交<br />可上传多个文件，请确保公章清晰可辨。',
          isShow(ruleForm) {
            return ruleForm.learn_status === '已毕业'
          }
        },
        {
          required: true,
          label: '在读证明',
          type: 'v-upload',
          model: 'PROOF_READING',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PROOF_READING' }
          },
          rules: { required: true, message: '请上传在读证明' },
          append:
            '未毕业学员提交加盖公章的在读证明<br/>申请者需要将本科或以上在读证明原件扫描或拍照后提交。<br> 可上传多个文件，请确保公章清晰可辨。',
          isShow(ruleForm) {
            return ruleForm.learn_status === '未毕业'
          }
        }
      ]
    }
  }
}
