export default function(_this) {
  return {
    id: 'interview_byzs',
    title: '学位证书和成绩单',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const {
          basic_info: basicInfo = {},
          attachments = [],
          submission_stage: submissionStage = 'FILLING'
        } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'DIPLOMA_CN') {
              result.DIPLOMA_CN.push(item)
            }
            if (item.file_type_id === 'REPORT_CARD_CN') {
              result.REPORT_CARD_CN.push(item)
            }
            return result
          },
          { ...basicInfo, DIPLOMA_CN: [], REPORT_CARD_CN: [] }
        )
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        // let [province, city] = data.city.split('-')
        // data.address_province = province
        // data.address_city = city
        const basicInfo = ['is_mba'].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
    },
    form: {
      next: { to: { query: { active: 'interview_ywjl' } }, isSubmit: true },
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-radio',
          values: [
            { label: '是', value: '1' },
            { label: '否', value: '0' }
          ],
          label: '是否为MBA学位',
          model: 'is_mba',
          rules: [{ required: true, message: '请选择', trigger: 'change' }]
        },
        {
          label: '学位证书',
          type: 'v-upload',
          model: 'DIPLOMA_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DIPLOMA_CN' }
          },
          append:
            '申请者需要将本科和硕士学位证书原件扫描或者拍照后提交。<br> 可上传多个文件，请确保证书号码清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        },
        {
          label: '成绩单',
          type: 'v-upload',
          model: 'REPORT_CARD_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'REPORT_CARD_CN' }
          },
          append:
            '申请者需要将本科和硕士阶段的成绩单原件扫描或拍照后提交。<br> 可上传多个文件，请确保公章清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        }
      ]
    }
  }
}
