import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  // ...(process.env.NODE_ENV === 'development' && {
  //   server: {
  //     host: 'dev.ezijing.com',
  //     https: {
  //       key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
  //       cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
  //     }
  //   }
  // }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '紫荆-工商管理博士DBA',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { hid: 'viewport', name: 'viewport', content: 'width=device-width, initial-scale=1' },
      // {
      //   name: 'keywords',
      //   content:
      //     '工商管理硕士,MBA硕士,免联考MBA,国际MBA,通用MBA,在职MBA,在线MBA,MBA,商学院,管理学,玛丽伍德大学,玛丽伍德,Marywood'
      // },
      // {
      //   name: 'description',
      //   content:
      //     '美国玛丽伍德大学（Marywood University）创办于 1915 年,Money评选的全美最具性价比大学,玛丽伍德大学是一所拥有128名全职教授、超过 3,000 名在校学生的综合性大学,大学设置超过100个本科、硕士及博士专业'
      // }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/vant',
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
