/**
 * 荣誉奖励
 */

export default function(_this) {
  return {
    id: 'application_info_honor',
    // title: '荣誉奖励',
    title: _this.$t('application.honorsAndAwards'),
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { honors: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        const honors = data.map(item => {
          return ['time', 'title', 'institution_cn'].reduce((result, key) => {
            result[key] = item[key] || ''
            return result
          }, {})
        })
        return { honors }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_training' } }, isSubmit: true },
      next: { to: { query: { active: 'application_tjx' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: _this.$t('application.acquisitionTime'),
          model: 'time',
          attrs: { type: 'date', valueFormat: 'yyyy-MM-dd', placeholder: '请选择获取时间' }
          // rules: [{ required: true, message: '请选择获取时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: _this.$t('application.honorsAndAwards'),
          model: 'title',
          attrs: { placeholder: '请输入荣誉奖励' }
          // rules: [{ required: true, message: '请输入荣誉奖励', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: _this.$t('application.certificateAuthority'),
          model: 'institution_cn',
          attrs: { placeholder: '请输入证书颁发机构' }
          // rules: [{ required: true, message: '请输入证书颁发机构', trigger: 'blur' }]
        }
      ]
    }
  }
}
