/**
 * 教育背景
 */

export default function (_this) {
  return {
    id: 'application_info_education',
    title: '教育背景',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      callback(data) {
        const { basic_info: basicInfo = {}, educations: list = [] } = _this.detail.material
        if (list.length > 0) {
          list[0].education_status = basicInfo.education_status
        }
        return list.length ? list : [{}]
      }
    },
    update: {
      beforeRequest(data) {
        const educations = data.map(item => {
          return ['start_date', 'end_date', 'school_type', 'school_name_cn', 'major_cn', 'degree'].reduce((result, key) => {
            result[key] = item[key]
            return result
          }, {})
        })
        const basicInfo = { education_status: data[0].education_status }
        return { basic_info: basicInfo, educations }
      },
      callback() {
        _this.getApplication()
      }
    },
    form: {
      hasAdd: true,
      options: { labelWidth: '140px' },
      appendItems: [
        {
          type: 'v-input',
          label: '当前教育状态',
          model: 'education_status',
          attrs: { placeholder: '请填写当前教育状态' },
          rules: [{ required: true, message: '请填写当前教育状态', trigger: 'blur' }],
          append: '<p style="color:#606266">当前教育状态(填写示例：本科在读/大四)</p>'
        }
      ],
      items: [
        {
          type: 'v-datepicker',
          label: '开始时间',
          model: 'start_date',
          attrs: {
            type: 'month',
            placeholder: '请选择教育开始时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育开始时间', trigger: 'blur' }]
        },
        {
          type: 'v-datepicker',
          label: '结束时间',
          model: 'end_date',
          attrs: {
            type: 'month',
            placeholder: '请选择教育结束时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育结束时间', trigger: 'blur' }],
          append: '<p style="color:#606266">在读学生填写预计毕业时间</p>'
        },
        {
          type: 'v-select',
          attrs: { placeholder: '请选择' },
          values: [{ value: '985院校' }, { value: '211院校' }, { value: '省重点' }, { value: '普通本科' }, { value: '专科院校' }],
          label: '学校类型',
          model: 'school_type',
          rules: [{ required: true, message: '请选择学校类型', trigger: 'change' }]
        },
        {
          type: 'v-input',
          label: '学校名称',
          model: 'school_name_cn',
          attrs: { placeholder: '请输入学校名称' },
          rules: [{ required: true, message: '请输入学校名称', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '专业名称',
          model: 'major_cn',
          attrs: { placeholder: '请输入专业名称' },
          rules: [{ required: true, message: '请输入专业名称', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          attrs: { placeholder: '请选择' },
          values: [
            { value: '专科' },
            { value: '本科' },
            { value: '本科/学士' },
            { value: '硕士研究生' },
            { value: '研究生/硕士' },
            { value: '博士研究生' },
            { value: '研究生/博士' },
            { value: '其他' }
          ],
          label: '学历/学位',
          model: 'degree',
          rules: [{ required: true, message: '请选择学历/学位', trigger: 'change' }]
        }
      ]
    }
  }
}
