export default function(_this) {
  return {
    required: true,
    id: 'interview_yynl',
    title: '语言能力证明',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'INTERNATIONAL_LANGUAGE_SCORE') {
              result.INTERNATIONAL_LANGUAGE_SCORE.push(item)
            }
            return result
          },
          { INTERNATIONAL_LANGUAGE_SCORE: [] }
        )
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_cjd' } } },
      submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: { 'label-position': 'top' },
      hint: '成绩单类型包括：CET-4，CET-6，TOEFL，IELTS等',
      items: [
        {
          required: true,
          type: 'v-upload',
          model: 'INTERNATIONAL_LANGUAGE_SCORE',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'INTERNATIONAL_LANGUAGE_SCORE' }
          }
        }
      ]
    }
  }
}
