export default function(_this) {
  return {
    id: 'interview_zp',
    title: '2寸照片',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        const PERSONAL_PHOTO_FOR_ID = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_PHOTO_FOR_ID'
        })
        return { PERSONAL_PHOTO_FOR_ID }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
        _this.$router.push({ path: this.$route.path, query: { active: 'interview_pay' } })
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_ywjl' } } },
      submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: {},
      items: [
        {
          type: 'v-upload',
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' },
            limit: 1
          },
          append:
            '申请者需要上传本人半年以内的两寸彩色近照。<br> 只需上传一个文件，且照片完整、干净。<br> 上传文件仅限“jpg,jpeg,gif,png”格式的图片文件，且文件小于10MB。'
        }
      ]
    }
  }
}
