/**
 * 申请声明
 */

export default function(_this) {
  return {
    id: 'application_declare',
    title: '申请声明',
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { submission_stage: submissionStage = 'FILLING' } = data.data.material
        const isSubmited = submissionStage !== 'FILLING'
        this.form.options.disabled = isSubmited
        if (isSubmited) {
          return { isAgree: [1] }
        }
        return { isAgree: [] }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      callback() {
        _this.getApplication()
        this.form.options.disabled = true
        // _this.$router.push({ path: this.$route.path, query: { active: 'application_pay' } })
        _this.$router.push({ path: '/my/interview' })
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'application_tjx' } } },
      submitText: '提交报名申请',
      model: { isAgree: [] },
      options: {},
      items: [
        {
          type: 'v-checkbox',
          values: [{ label: '同意', value: 1 }],
          model: 'isAgree',
          rules: [{ required: true, message: '请阅读协议', trigger: 'change' }],
          prepend:
            '<p>本人自愿申请紫荆-加州整合大学应用心理学硕士项目，所有申请表格内填写的内容属实，本科学士学位证书属实，没有弄虚作假的行为。如有虚假，愿承担一切法 律责任。</p>'
        }
      ]
    }
  }
}
