/**
 * 申请声明
 */

export default function (_this) {
  return {
    id: 'application_declare',
    title: '申请声明',
    visible() {
      return _this.visible
    },
    get: {
      callback() {
        return _this.isSubmitted ? { isAgree: [1] } : { isAgree: [] }
      }
    },
    onUpdate() {
      _this.handleSubmit()
    },

    form: {
      submitText: '提交报名申请',
      model: { isAgree: [] },
      items: [
        {
          type: 'v-checkbox',
          values: [{ label: '同意', value: 1 }],
          model: 'isAgree',
          rules: [{ required: true, message: '请阅读协议', trigger: 'change' }],
          prepend: `<p>1、本人知晓此申请表及所附文件将作为申请美国帕克大学本升硕项目面试和背景评估的参考依据，一旦成功录取，有关资料将作为学生信息存档。</p>
            <p>2、本人声明所填资料正确无误，知晓任何不真实的信息或不诚信的行为，均会影响申请结果，已取得的成绩和资格会被取消。我理解并同意所有报名材料归紫荆教育所有，无论考生录取与否均不退回。我授权紫荆教育使用报名表中的信息查询本人学习和工作记录。</p>`
        }
      ]
    }
  }
}
