import { STAGE_LIST } from '../../index'

/**
 * 推荐信
 */

export default function (_this) {
  return {
    id: 'application_tjx',
    title: '推荐信',
    visible() {
      return _this.visible
    },
    get: {
      callback(data) {
        const list = _this.detail.material.reco_letters || []
        return list.length ? list : [{}, {}]
      }
    },
    update: {
      beforeRequest(data) {
        return { reco_letters: data }
      }
    },
    form: {
      minlength: 2,
      hasAdd: true,

      aside: {
        prepend: {
          html: '<p style="color:#33C011;">推荐人已完成</p>',
          visible(data) {
            return !!data.letter_content
          }
        },
        buttons: [
          {
            text: '再次邀请',
            visible(data) {
              const editable = ['PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION'].includes(_this.detail.material.submission_stage)
              return data.id && !data.letter_content && editable
            },
            onClick(data) {
              _this.sendToProvider(data)
            }
          },
          {
            text: '更换推荐人',
            visible(data) {
              const editable = ['PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION'].includes(_this.detail.material.submission_stage)
              return data.id && !data.letter_content && editable
            },
            onClick(data, $form) {
              $form.validate().then(() => {
                _this.changeProvider(data)
              })
            }
          }
        ]
      },
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-input',
          label: '推荐人姓名',
          model: 'provider_name',
          attrs: { placeholder: '请输入推荐人姓名' },
          rules: [{ required: true, message: '请输入推荐人姓名', trigger: 'blur' }]
        },

        {
          type: 'v-input',
          label: '推荐人电话',
          model: 'provider_phone_number',
          attrs: { placeholder: '请输入推荐人电话', maxlength: 11 },
          rules: [{ required: true, pattern: /^1[3-9]\d{9}$/, message: '请输入推荐人电话', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '推荐人邮箱',
          model: 'provider_email',
          attrs: { placeholder: '请输入推荐人邮箱' },
          rules: [{ type: 'email', required: true, message: '请输入推荐人邮箱', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [{ value: '老师/导师' }, { value: '领导' }, { value: '同学' }, { value: '同事' }, { value: '亲属' }, { value: '朋友' }, { value: '其他' }],
          label: '与推荐人关系',
          model: 'provider_relationship',
          rules: [{ required: true, message: '请选择与推荐人关系', trigger: 'change' }]
        }
      ]
    }
  }
}
