export default {
  id: 'interview_xwzsywzm',
  title: '学位证书英文证明',
  get: {
    callback(data) {
      const { attachments = [] } = _this.detail.material

      const DEGREE_CERT_EN = attachments.filter(item => {
        return item.file_type_id === 'DEGREE_CERT_EN'
      })
      return { DEGREE_CERT_EN }
    }
  },
  form: {
    hasSubmit: false,
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'DEGREE_CERT_EN',
        attrs: {
          action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
          deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
          data: { file_type: 'DEGREE_CERT_EN' }
        },
        append: '请将学校出具的学位证书英文证明原件扫描或者拍照后提交。'
      }
    ]
  }
}
