export default function(_this) {
  return {
    id: 'admission_zp',
    title: '证件照片',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = ['FILLING', 'PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION', 'INTERVIEW', 'PAYMENT', 'REGISTRATION', 'CLOSED']
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const PERSONAL_PHOTO_FOR_ID = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_PHOTO_FOR_ID'
        })
        return { PERSONAL_PHOTO_FOR_ID }
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_ywjl' } } },
      next: { to: { query: { active: 'admission_xy' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' },
            accept: 'image/*',
            limit: 1
          },
          append: '申请者需要上传本人半年以内的彩色近照。<br> 只需上传一个文件，且照片完整、干净。<br> 上传文件仅限“jpg,jpeg,gif,png”格式的图片文件，且文件小于10MB。'
        }
      ]
    }
  }
}
