import { STAGE_LIST } from '../../index'

export default function(_this) {
  return {
    id: 'admission_xy',
    title: '入学协议',
    required: true,
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) > 7
        const ADMISSION_AGREEMENT = attachments.filter(item => {
          return item.file_type_id === 'ADMISSION_AGREEMENT'
        })
        return { ADMISSION_AGREEMENT }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'CLOSED' }
      },
      callback() {
        _this.$message({ type: 'success', message: '提交成功' })
        _this.getApplication()
        this.form.options.disabled = true
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_xfjn' } } },
      submitText: '提交',
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-upload',
          required: true,
          label: '入学协议',
          model: 'ADMISSION_AGREEMENT',
          rules: [{ required: true, message: '请上传', trigger: 'change' }],
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'ADMISSION_AGREEMENT' }
          },
          prepend:
            // <p><a href="https://webapp-pub.ezijing.com/project/sbu-plus/%E5%85%A5%E5%AD%A6%E5%8D%8F%E8%AE%AE.pdf" target="_blank" download="入学协议">下载入学协议</a></p>
            `<p>申请者可将签字后的入学协议原件扫描或拍照后提交。</p>
            <p>学员应仔细阅读《入学协议》以及课程介绍，如对入学协议或课程有异议，请第一时间与课程顾问咨询确认。请用A4纸打印后，在入学协议上签上姓名和日期，内容需显示完整、格式整齐、字迹清晰可辨。上传文件仅限“jpg,jpeg,pdf,png”格式，文件小于10Mb。</p>
          `
        }
      ]
    }
  }
}
