/**
 * 个人信息
 */

export default function (_this) {
  return {
    id: 'application_info_first',
    title: '个人信息',
    required: true,
    visible() {
      return this.tabActive === 'application_info_first'
    },
    get: {
      callback(data) {
        const { basic_info: basicInfo = {}, attachments = [] } = _this.detail.material

        const attachment = attachments.reduce(
          (result, item) => {
            const types = ['ID_CARD_FRONT', 'ID_CARD_BACK', 'HK_ID_CARD', 'PASSPORT', 'OTHER_ID_CARD_PHOTO']
            types.forEach(type => {
              if (item.file_type_id === type) {
                result[type].push(item)
              }
            })
            return result
          },
          { ID_CARD_FRONT: [], ID_CARD_BACK: [], HK_ID_CARD: [], PASSPORT: [], OTHER_ID_CARD_PHOTO: [] }
        )
        basicInfo.id_type = basicInfo.id_type === '护照' ? '中国护照' : basicInfo.id_type
        return Object.assign({}, basicInfo, attachment)
      }
    },
    update: {
      beforeRequest(data) {
        const basicInfo = ['phone_number', 'email', 'id_type'].reduce((result, key) => {
          result[key] = data[key]
          return result
        }, {})
        return { basic_info: basicInfo }
      }
    },
    form: {
      submitText: '下一步',
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-input',
          label: '手机号',
          model: 'phone_number',
          attrs: { placeholder: '请输入手机号', maxlength: 11 },
          rules: [{ required: true, pattern: /^1[3-9]\d{9}$/, message: '请输入手机号', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '邮箱',
          model: 'email',
          attrs: { placeholder: '请输入邮箱' },
          rules: [{ type: 'email', required: true, message: '请输入邮箱', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [{ value: '居民身份证' }, { value: '港澳台身份证' }, { value: '中国护照' }, { value: '其他' }],
          label: '证件类型',
          model: 'id_type',
          attrs: { placeholder: '请选择证件类型' },
          rules: [{ required: true, message: '请选择证件类型', trigger: 'change' }]
        },
        // 身份证照片(背面)
        {
          type: 'v-upload',
          label: '身份证人像面',
          model: 'ID_CARD_BACK',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'ID_CARD_BACK' },
            limit: 1,
            accept: 'image/*',
            image: 'https://zws-imgs-pub.ezijing.com/pc/cu/id_card_back.png'
          },
          rules: [{ type: 'array', required: true, message: '请上传身份证照片人像面', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '居民身份证'
          }
        },
        // 身份证照片(正面）
        {
          type: 'v-upload',
          label: '身份证国徽面',
          model: 'ID_CARD_FRONT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'ID_CARD_FRONT' },
            limit: 1,
            accept: 'image/*',
            image: 'https://zws-imgs-pub.ezijing.com/pc/cu/id_card_front.png'
          },
          rules: [{ type: 'array', required: true, message: '请上传身份证照片国徽面', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '居民身份证'
          }
        },
        // 港澳台身份证
        {
          type: 'v-upload',
          label: '港澳台身份证',
          model: 'HK_ID_CARD',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'HK_ID_CARD' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传港澳台身份证', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '港澳台身份证'
          }
        },
        // 中国护照
        {
          type: 'v-upload',
          label: '中国护照',
          model: 'PASSPORT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PASSPORT' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传中国护照', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '中国护照'
          }
        },
        // 其他证件
        {
          type: 'v-upload',
          label: '其他证件',
          model: 'OTHER_ID_CARD_PHOTO',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'OTHER_ID_CARD_PHOTO' },
            limit: 1,
            accept: 'image/*'
          },
          rules: [{ type: 'array', required: true, message: '请上传其他证件', trigger: 'change' }],
          isShow(data) {
            return data.id_type === '其他'
          }
        }
      ]
    }
  }
}
