export default function(_this) {
  return {
    id: 'admission_xy',
    title: '入学协议',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const ADMISSION_AGREEMENT = attachments.filter(item => {
          return item.file_type_id === 'ADMISSION_AGREEMENT'
        })
        return { ADMISSION_AGREEMENT }
      }
    },
    form: {
      next: { to: { query: { active: 'admission_xfjn' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'ADMISSION_AGREEMENT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'ADMISSION_AGREEMENT' }
          },
          prepend: `
          <p>第一步：点击下载按键获取入学协议</p>
          <p><a href="https://webapp-pub.ezijing.com/project/caas/CAAS%20%E9%A4%90%E9%A5%AEMBA%20%20%E5%85%A5%E5%AD%A6%E5%8D%8F%E8%AE%AE.docx" target="_blank" download>下载入学协议</a></p>
          <p>第二步：申请者可将签字后的入学协议原件扫描或拍照后提交。学员应仔细阅读《入学协议》以及课程介绍，如对入学协议或课程有异议，请第一时间与课程顾问咨询确认。请用A4纸打印后，在入学协议上签上姓名和日期，内容需显示完整、格式整齐、字迹清晰可辨。点击下方按钮，上传文件</p>
        `
        }
      ]
    }
  }
}
