import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: 'CAAS瑞士美食艺术管理大学-餐饮管理MBA-清华控股旗下在线教育品牌',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { hid: 'viewport', name: 'viewport', content: 'width=device-width, initial-scale=1' },
      {
        hid: 'keywords',
        name: 'keywords',
        content:
          '瑞士美食艺术管理大学,瑞士恺撒里兹大学,瑞士美食艺术管理学院,瑞士美食艺术管理大学排名,瑞士美食艺术管理大学学费,瑞士餐饮管理MBA,瑞士美食艺术管理学院排名,瑞士美食艺术管理学校,瑞士餐饮管理学费,seg瑞士餐饮管理,餐饮管理专业,餐饮管理课程,餐饮管理专业排名,餐饮管理app,餐饮管理博士,餐饮管理本科,餐饮管理大学香港,餐饮管理大学排名,餐饮管理大学排名2020,餐饮管理排名,餐饮管理集团'
      },
      {
        hid: 'description',
        name: 'description',
        content:
          '瑞士美食艺术管理大学,2021年QS世界大学排名美食餐饮管理专业排名全球第1,是唯一上榜的美食艺术院校.全球最佳餐饮业MBA,目标是培养未来餐饮行业领军人才及未来领袖,学习方式灵活,课程采用混合式教学模式,不用出国就可以享受瑞士及国内清华、北大、人大等顶尖的教育资源,其不仅涵盖了MBA课程体系中必要的商业核心课程,同时专注于高端餐饮业,共同培养学生的领导力和创造力,扩展学生的国际视野,使学生提升专业的美食艺术知识和餐饮企业管理技能,成为具有综合管理能力和深厚行业底蕴的餐饮界人才,目前在读学员均来自万豪、洲际、凯悦、希尔顿等国际高端品牌及海底捞、全聚德、喜茶、奈雪、西贝等国内大中型餐饮企业。'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/vant',
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
