import { STAGE_LIST } from '../../index'
export default function (_this) {
  return {
    required: true,
    id: 'admission_tjx',
    title: '推荐信',
    visible() {
      return _this.isPay
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material

        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) >= 6
        return attachments.reduce(
          (result, item) => {
            item.disabled = item.upload_operator_user_id !== _this.user?.id
            if (item.file_type_id === 'RECOMMENDATION_LETTER') {
              result.RECOMMENDATION_LETTER.push(item)
            }
            if (item.file_type_id === 'RECOMMENDATION_LETTER_2') {
              result.RECOMMENDATION_LETTER_2.push(item)
            }
            return result
          },
          { RECOMMENDATION_LETTER: [], RECOMMENDATION_LETTER_2: [] }
        )
      }
    },
    // update: {
    //   action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
    //   beforeRequest(data) {
    //     return { submission_stage: 'INTERVIEW_APPLICATION' }
    //   },
    //   callback() {
    //     this.form.options.disabled = true
    //     _this.dialogVisible = true
    //     _this.getApplication()
    //   },
    //   errorCallback() {
    //     _this.completeVisible = true
    //   }
    // },
    form: {
      prev: { to: { query: { active: 'admission_cjd' } } },
      next: { to: { query: { active: 'admission_grcs' } } },
      hasSubmit: false,
      // submitText: '申请面试',
      // model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: {},
      prepend: '请上传两封推荐人署名的推荐信原件照片或扫描件(英文)',
      items: [
        {
          type: 'v-upload',
          model: 'RECOMMENDATION_LETTER',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RECOMMENDATION_LETTER' },
            accept: 'image/*',
            limit: 1
          }
        },
        {
          type: 'v-upload',
          model: 'RECOMMENDATION_LETTER_2',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RECOMMENDATION_LETTER_2' },
            accept: 'image/*',
            limit: 1
          }
        }
      ]
    }
  }
}
