import { STAGE_LIST } from '../../index'
export default function(_this) {
  return {
    id: 'interview_grcs',
    title: '个人陈述',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material

        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) >= 2
        const PERSONAL_STATEMENT = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_STATEMENT'
        })
        return { PERSONAL_STATEMENT }
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_tjx' } } },
      next: { to: { query: { active: 'interview_byzs' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'PERSONAL_STATEMENT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_STATEMENT' },
            limit: 1
          },
          append: '请上传您的个人陈述（英文）'
        }
      ]
    }
  }
}
