export default function (_this) {
  return {
    required: true,
    id: 'interview_ywjl',
    title: '英文简历',
    get: {
      callback(data) {
        const { attachments = [] } = _this.detail.material
        const RESUME_EN = attachments.filter(item => item.file_type_id === 'RESUME_EN')
        return { RESUME_EN }
      }
    },
    form: {
      hasSubmit: false,
      items: [
        {
          required: true,
          type: 'v-upload',
          model: 'RESUME_EN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RESUME_EN' }
          },
          append: `
        <p>请下载填写英文简历模板后上传 [<a href="https://webapp-pub.oss-cn-beijing.aliyuncs.com/project/syracuse-plus/sit-en-resume.doc" target="_blank" download="英文简历模板">下载模板</a>]</p>
        <p>请将英文简历填写完存为"pdf"格式上传，文件小于10MB。</p>`
        }
      ]
    }
  }
}
