export default {
  id: 'admission_byzs',
  title: '毕业证书注册备案表',
  get: {
    action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
    callback(data) {
      const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
      const stageList = [
        'FILLING',
        'PREPAYMENT',
        'INTERVIEW_APPLICATION',
        'AUDITION',
        'INTERVIEW',
        'PAYMENT',
        'REGISTRATION',
        'CLOSED'
      ]
      this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
      const DIPLOMA_FILING_TABLE = attachments.filter(item => {
        return item.file_type_id === 'DIPLOMA_FILING_TABLE'
      })
      return { DIPLOMA_FILING_TABLE }
    }
  },
  form: {
    prev: { to: { query: { active: 'admission_cjd' } } },
    next: { to: { query: { active: 'admission_ywjl' } } },
    hasButton: false,
    options: {},
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'DIPLOMA_FILING_TABLE',
        attrs: {
          action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
          deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
          data: { file_type: 'DIPLOMA_FILING_TABLE' }
        },
        prepend: `
        <p>学信网《教育部学历证书电子注册备案表》[<a href="https://zws-imgs-pub.oss-cn-beijing.aliyuncs.com/pc/sofia/%E6%AF%95%E4%B8%9A%E8%AF%81%E4%B9%A6%E6%B3%A8%E5%86%8C%E5%A4%87%E6%A1%88%E8%A1%A8.pdf" target="_blank" download="毕业证书注册备案表">下载流程表</a>]
        <p>学历在学信网可查的同学，请下载学信网电子注册备案表提交到系统，具体获取流程请</p>
        <p>下载附件 上传文件仅限“jpg,jpeg,pdf,png”格式，文件小于10Mb。</p>
      `
      }
    ]
  }
}
