export default {
  id: 'interview_xwzs',
  title: '学位证书',
  get: {
    callback(data) {
      const { attachments = [] } = _this.detail.material

      const DEGREE_CERT_CN = attachments.filter(item => {
        return item.file_type_id === 'DEGREE_CERT_CN'
      })
      return { DEGREE_CERT_CN }
    }
  },
  form: {
    hasSubmit: false,
    items: [
      {
        type: 'v-upload',
        required: true,
        model: 'DEGREE_CERT_CN',
        attrs: {
          action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
          deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
          data: { file_type: 'DEGREE_CERT_CN' }
        },
        append: '申请者需要将学位证书原件扫描或者拍照后提交。<br>可上传多个文件，请确保证书号码清晰可辨。<br>上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
      }
    ]
  }
}
