import { getUser, logout } from '@/api/my'
export const state = () => ({
  user: {}
})

export const mutations = {
  setUser(state, user) {
    state.user = user
  },
  removeUser(state) {
    state.user = {}
  }
}

export const actions = {
  getUser({ commit }) {
    getUser().then(response => {
      commit('setUser', response.data)
    })
  },
  // 退出登录
  logout({ commit }) {
    return logout().then(response => {
      commit('setUser', {})
      return response
    })
  },
  // 检测登录状态
  async checkLogin({ commit }) {
    const isLogin = await getUser()
      .then(response => {
        commit('setUser', response.data)
        return true
      })
      .catch(() => {
        commit('setUser', {})
        return false
      })
    return isLogin
  }
}
