import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '紫荆教育-美国印第安纳大学Kelley商学院金融学硕士',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { hid: 'viewport', name: 'viewport', content: 'width=device-width, initial-scale=1' },
      {
        hid: 'keywords',
        name: 'keywords',
        content:
          '理金融硕士,在职金融硕士,国际金融硕士,美国金融硕士,美国印第安纳大学,印第安纳大学,Kelley商学院,MSF,金融人才,商学院,在线金融硕士'
      },
      {
        hid: 'description',
        name: 'description',
        content:
          '印第安纳大学布鲁明顿分校（IUB）是美国 “公立常春藤” (Public Ivy) 院校.Kelley商学院是印第安纳大学伯明顿分校的明星学院,自1920年创立以来一直被认为是世界上历史最悠久和领先的商学院之一,被誉为全美CFO摇篮,华尔街金融人才的主要培养院校之一.'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/vant',
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
