import path from 'path'
import fs from 'fs'
// import routes from './router/routes'

let config = {}
if (process.env.NODE_ENV === 'production') {
  config = {
    env: {
      projectId: '1012',
      newProjectId: '9946887509442560',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth'
    },
    server: { port: 2048, host: '0.0.0.0' }
  }
} else {
  config = {
    env: {
      projectId: '1012',
      newProjectId: '9946887509442560',
      baseURL: 'https://project-api.ezijing.com',
      loginURL: 'https://login.ezijing.com/auth'
    },
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }
}

export default {
  // ssr: false,
  ...config,
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '清控紫荆教育留学官网_美国留学读研_美国研究生金融硕士_美国工商管理博士_美国管理学硕士_直申美国名校',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      {
        name: 'viewport',
        content: 'width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover'
      },
      {
        hid: 'keywords',
        name: 'keywords',
        content: '美国留学，美国读研，美国读博，美国研究生，美国博士，出国读研，出国留学，紫荆教育，清控紫荆教育'
      },
      {
        hid: 'description',
        name: 'description',
        content:
          '清控紫荆教育留学官网，为出国留学的学生、在职人士提供美国留学、美国读研究生、美国管理学硕士、美国工商管理硕士、美国读博士申请服务，助力中国学生直申名校，省时省钱！'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: ['@/plugins/router', '@/plugins/axios', '@/plugins/element-ui', '@/plugins/vue-swiper.js'],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: [],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    // extendRoutes: routes,
    middleware: ['device']
  }
}
