/**
 * 学习目的
 */

export default function (_this) {
  return {
    id: 'application_info_answer',
    title: '学习目的',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      callback(data) {
        const { answers = [], submission_stage: submissionStage = 'FILLING' } = _this.detail.material

        const [first = {}, second = {}] = answers
        return {
          qid1: first.qid || '1',
          question1: '您为什么要申请美国帕克大学硕士项目？',
          answer1: first.answer,
          qid2: second.qid || '2',
          question2: '您的短期和长期职业发展目标是什么？您打算如何达成此愿景？',
          answer2: second.answer
        }
      }
    },
    update: {
      beforeRequest(data) {
        return {
          answers: [
            { qid: data.qid1, question: data.question1, answer: data.answer1 },
            { qid: data.qid2, question: data.question2, answer: data.answer2 }
          ]
        }
      }
    },
    form: {
      items: [
        {
          type: 'v-input',
          label: '您为什么要申请美国帕克大学硕士项目？（60字以上，1000字以内）',
          model: 'answer1',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label: '您的短期和长期职业发展目标是什么？您打算如何达成此愿景？（60字以上，1000字以内）',
          model: 'answer2',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        }
      ]
    }
  }
}
