export default function (_this) {
  return {
    required: false,
    id: 'interview_tjx',
    title: '推荐信',
    get: {
      callback(data) {
        const { attachments = [] } = _this.detail.material

        return attachments.reduce(
          (result, item) => {
            item.disabled = item.upload_operator_user_id !== _this.user?.id
            if (item.file_type_id === 'RECOMMENDATION_LETTER') {
              result.RECOMMENDATION_LETTER.push(item)
            }
            if (item.file_type_id === 'RECOMMENDATION_LETTER_2') {
              result.RECOMMENDATION_LETTER_2.push(item)
            }
            return result
          },
          { RECOMMENDATION_LETTER: [], RECOMMENDATION_LETTER_2: [] }
        )
      }
    },

    form: {
      hasSubmit: false,
      prepend: '请上传两封推荐人署名的推荐信原件照片或扫描件(英文)',
      items: [
        {
          type: 'v-upload',
          model: 'RECOMMENDATION_LETTER',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RECOMMENDATION_LETTER' },
            accept: 'image/*',
            limit: 1
          }
        },
        {
          type: 'v-upload',
          model: 'RECOMMENDATION_LETTER_2',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RECOMMENDATION_LETTER_2' },
            accept: 'image/*',
            limit: 1
          }
        }
      ]
    }
  }
}
