import Vue from 'vue'
import VueI18n from 'vue-i18n'
import zhCN from '@/langs/zh-CN'
import enUS from '@/langs/en-US'

Vue.use(VueI18n)

export default ({ app, store }) => {
  app.i18n = new VueI18n({
    locale: store.state.locale,
    fallbackLocale: 'zh-CN',
    messages: { 'zh-CN': zhCN, 'en-US': enUS }
  })
}
