/**
 * 学习目的
 */

export default function(_this) {
  return {
    id: 'application_info_answer',
    title: '学习目的',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { answers = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        const [first = {}, second = {}] = answers
        return {
          qid1: first.qid || '1',
          question1: '您为什么要申请索菲亚大学金融方向工商管理硕士项目?(60字以上，1000字以内)',
          answer1: first.answer,
          qid2: second.qid || '2',
          question2: '您的短期和长期职业发展目标是什么?您打算如何达成此愿景?(60字以上，1000字以内)',
          answer2: second.answer
        }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}/put`,
      beforeRequest(data) {
        return {
          answers: [
            { qid: data.qid1, question: data.question1, answer: data.answer1 },
            { qid: data.qid2, question: data.question2, answer: data.answer2 }
          ]
        }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_career' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_training' } }, isSubmit: true },
      options: {},
      items: [
        {
          type: 'v-input',
          label: '您为什么要申请索菲亚大学金融方向工商管理硕士项目?(60字以上，1000字以内)',
          model: 'answer1',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        },
        {
          type: 'v-input',
          label: '您的短期和长期职业发展目标是什么?您打算如何达成此愿景?(60字以上，1000字以内)',
          model: 'answer2',
          attrs: { type: 'textarea', rows: '8', maxlength: '1000', style: 'width:100%' },
          rules: [
            { required: true, message: '请输入', trigger: 'blur' },
            { min: 60, max: 1000, message: '长度在 60 到 1000 个字符', trigger: 'blur' }
          ]
        }
      ]
    }
  }
}
