/**
 * 相关附件
 */
export default function(_this) {
  return {
    id: 'application_info_attachment',
    title: '相关附件',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'DIPLOMA_CN') {
              result.DIPLOMA_CN.push(item)
            }
            if (item.file_type_id === 'DEGREE_CERT_CN') {
              result.DEGREE_CERT_CN.push(item)
            }
            if (item.file_type_id === 'RESUME_EN') {
              result.RESUME_EN.push(item)
            }
            if (item.file_type_id === 'PERSONAL_PHOTO_FOR_ID') {
              result.PERSONAL_PHOTO_FOR_ID.push(item)
            }
            return result
          },
          { DIPLOMA_CN: [], DEGREE_CERT_CN: [], RESUME_EN: [], PERSONAL_PHOTO_FOR_ID: [] }
        )
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_honor' } } },
      next: { to: { query: { active: 'application_declare' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          label: '毕业证书',
          required: true,
          model: 'DIPLOMA_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DIPLOMA_CN' }
          },
          append:
            '申请者需要将本科或以上毕业证书原件扫描或者拍照后提交。<br> 可上传多个文件，请确保证书号码清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        },
        {
          type: 'v-upload',
          label: '学位证书',
          required: true,
          model: 'DEGREE_CERT_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DEGREE_CERT_CN' }
          },
          append:
            '申请者需要将学位证书原件扫描或者拍照后提交。<br>可上传多个文件，请确保证书号码清晰可辨。<br>上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        },
        {
          type: 'v-upload',
          label: '英文简历',
          required: true,
          model: 'RESUME_EN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RESUME_EN' }
          },
          append: `
          <p>请下载填写英文简历模板后上传 [<a href="https://zws-imgs-pub.ezijing.com/pc/kelley/%E8%8B%B1%E6%96%87%E7%AE%80%E5%8E%86.docx" download="英文简历模板">下载模板</a>]</p>
          <p>请将英文简历填写完存为"pdf"格式上传，文件小于10MB。</p>`
        },
        {
          type: 'v-upload',
          label: '2寸照片',
          required: true,
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' },
            limit: 1
          },
          append:
            '申请者需要上传本人半年以内的两寸彩色近照。<br> 只需上传一个文件，且照片完整、干净。<br> 上传文件仅限“jpg,jpeg,gif,png”格式的图片文件，且文件小于10MB。'
        }
      ]
    }
  }
}
