import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '儿童教育硕士-儿童心理与教育硕士-在职教育学硕士-康博斯威尔大学教育学硕士项目',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: '' },
      {
        name: 'keywords',
        content:
          '教育学硕士,在职教育学硕士,国际教育学硕士,美国教育学硕士,美国康博斯威尔大学,康博斯威尔大学,在线教育学硕士,幼师,园长,幼教机构负责人,幼教行业投资,幼教教材教具提供商,蒙台梭利,华德福,瑞吉欧,家庭咨询师,亲子咨询师,父母教育,正面管教'
      },
      {
        name: 'description',
        content:
          '美国康博斯威尔大学，全美排名第21的儿童心理与教育学硕士，【儿童心理与教育学名师】联合授课，学制1.5年，仅需7.5万，学位证书与出国留学所获得的证书相同！'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
