import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: 'CAAS瑞士美食艺术管理大学-餐饮管理MBA-清华控股旗下在线教育品牌',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { hid: 'viewport', name: 'viewport', content: 'width=device-width, initial-scale=1' },
      {
        hid: 'keywords',
        name: 'keywords',
        content:
          '瑞士酒店管理大学,瑞士酒店管理学院,瑞士酒店管理大学排名,瑞士酒店管理大学学费,瑞士酒店管理MBA,瑞士酒店管理学院排名,瑞士酒店管理学校,瑞士酒店管理学费,seg瑞士酒店管理,酒店管理专业,酒店管理课程,酒店管理专业排名,酒店管理app,酒店管理博士,酒店管理本科,酒店管理大学香港,qs酒店管理大学排名,酒店管理大学排名2020,酒店管理排名,酒店管理集团'
      },
      {
        hid: 'description',
        name: 'description',
        content:
          '瑞士酒店管理大学,2021年QS世界大学排名酒店管理专业综合排名位列世界第4。全球首款款待业MBA,目标是培养未来文旅行业领军人才及未来领袖,课程采用混合式教学模式,不用出国就可以享受瑞士及国内清华、北大、人大等顶尖的教育资源。学习方式灵活,更加符合在文旅行业高层管理人员及有志于从事款待业工作的学习者；目前在读学员均来自万豪、洲际、凯悦、希尔顿等国际高端品牌及锦江、华住、东呈等国内大中型文旅企业。'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/vant',
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
