/**
 * 申请声明
 */

export default function(_this) {
  return {
    id: 'application_declare',
    title: '申请声明',
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { submission_stage: submissionStage = 'FILLING' } = data.data.material
        const isSubmited = submissionStage !== 'FILLING'
        this.form.options.disabled = isSubmited
        if (isSubmited) {
          return { isAgree: [1] }
        }
        return { isAgree: [] }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      callback() {
        _this.getApplication()
        this.form.options.disabled = true
        _this.$router.push({ path: this.$route.path, query: { active: 'application_pay' } })
        // _this.$router.push({ path: '/my/interview' })
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_honor' } } },
      submitText: '提交报名申请',
      model: { isAgree: [] },
      options: {},
      items: [
        {
          type: 'v-checkbox',
          values: [{ label: '同意', value: 1 }],
          model: 'isAgree',
          rules: [{ required: true, message: '请阅读协议', trigger: 'change' }],
          prepend:
            '<p>我提供的所有报名材料信息皆准确和完整。我同意在需要的情况下提交原件以确认我的报名资格。由于报名材料中的虚假、错误信息或重大遗漏导致不录取或取消学籍的后果由我个人承担。 我理解并同意所有报名材料归紫荆教育所有，无论考生录取与否均不退回。我授权紫荆教育使用报名表中的信息查询本人学习和工作记录。</p>'
        }
      ]
    }
  }
}
