import { STAGE_LIST } from '../../index'
export default function(_this) {
  return {
    id: 'interview_zp',
    title: '个人照片',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material

        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) > 2
        const PERSONAL_PHOTO_FOR_ID = attachments.filter(item => {
          return item.file_type_id === 'PERSONAL_PHOTO_FOR_ID'
        })
        return { PERSONAL_PHOTO_FOR_ID }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'INTERVIEW_APPLICATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'interview_yynl' } } },
      submitText: '申请面试',
      model: { submission_stage: 'INTERVIEW_APPLICATION' },
      options: { 'label-position': 'top' },
      items: [
        {
          type: 'v-upload',
          model: 'PERSONAL_PHOTO_FOR_ID',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PERSONAL_PHOTO_FOR_ID' },
            limit: 1
          },
          append: '申请者需提交白底两寸个人照片<br> 确保图片清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于5MB'
        }
      ]
    }
  }
}
