export default function(_this) {
  return {
    id: 'admission_xy',
    title: _this.$t('application.admissionAgreement'),
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = ['FILLING', 'PREPAYMENT', 'INTERVIEW_APPLICATION', 'AUDITION', 'INTERVIEW', 'PAYMENT', 'REGISTRATION', 'CLOSED']
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 6
        const ADMISSION_AGREEMENT = attachments.filter(item => {
          return item.file_type_id === 'ADMISSION_AGREEMENT'
        })
        return { ADMISSION_AGREEMENT }
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'REGISTRATION' }
      },
      callback() {
        this.form.options.disabled = true
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      // next: { to: { query: { active: 'admission_xfjn' } } },
      submitText: _this.$t('application.submit'),
      options: { disabled: false },
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'ADMISSION_AGREEMENT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'ADMISSION_AGREEMENT' }
          },
          rules: [{ type: 'array', required: true, message: '请上传入学协议', trigger: 'change' }],
          prepend: `<p>${_this.$t('application.admissionAgreementContent')}</p>`
        }
      ]
    }
  }
}
