/**
 * 荣誉奖励
 */

export default function (_this) {
  return {
    id: 'application_info_honor',
    title: '荣誉奖励',
    visible() {
      return _this.visible
    },
    get: {
      callback(data) {
        const { attachments = [], honors: list = [] } = _this.detail.material
        const CERTIFICATE_OF_HONOR = attachments.filter(item => {
          return item.file_type_id === 'CERTIFICATE_OF_HONOR'
        })
        return list.length ? list.map(item => Object.assign({}, item, { CERTIFICATE_OF_HONOR })) : [{ CERTIFICATE_OF_HONOR }]
      }
    },
    update: {
      beforeRequest(data) {
        const honors = data.map(item => {
          return ['time', 'title', 'institution_cn'].reduce((result, key) => {
            result[key] = item[key] || ''
            return result
          }, {})
        })
        return { honors }
      }
    },
    form: {
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: '获取时间',
          model: 'time',
          attrs: { type: 'date', valueFormat: 'yyyy-MM-dd', placeholder: '请选择获取时间' }
          // rules: [{ required: true, message: '请选择获取时间', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '荣誉奖励',
          model: 'title',
          attrs: { placeholder: '请输入荣誉奖励' }
          // rules: [{ required: true, message: '请输入荣誉奖励', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '证书颁发机构',
          model: 'institution_cn',
          attrs: { placeholder: '请输入证书颁发机构' }
          // rules: [{ required: true, message: '请输入证书颁发机构', trigger: 'blur' }]
        }
      ],
      appendItems: [
        // 推荐信附件
        {
          type: 'v-upload',
          label: '荣誉证书附件',
          model: 'CERTIFICATE_OF_HONOR',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'CERTIFICATE_OF_HONOR' },
            accept: 'image/*'
          },
          class: 'upload-attachments'
        }
      ]
    }
  }
}
