/**
 * 报名申请相关的自定义路由
 */

export default (routes, resolve) => {
  routes.push(
    {
      path: '/my',
      component: resolve(__dirname, '../layouts/normal.vue'),
      props: { hasFooter: false },
      children: [
        {
          name: 'apply',
          path: '',
          component: resolve(__dirname, '../modules/my/welcome/index.vue'),
          meta: { requiredLogin: true }
        },
        {
          name: 'account',
          path: 'account',
          component: resolve(__dirname, '../modules/my/account/index.vue'),
          meta: { requiredLogin: true }
        },
        {
          path: 'application',
          component: resolve(__dirname, '../modules/my/application/index.vue'),
          meta: { requiredLogin: true }
        },
        {
          path: 'interview',
          component: resolve(__dirname, '../modules/my/interview/index.vue'),
          meta: { requiredLogin: true }
        },
        {
          path: 'review',
          component: resolve(__dirname, '../modules/my/review/index.vue'),
          meta: { requiredLogin: true }
        },
        {
          path: 'admission',
          component: resolve(__dirname, '../modules/my/admission/index.vue'),
          meta: { requiredLogin: true }
        }
      ]
    },
    // 推荐信
    {
      path: '/letter',
      component: resolve(__dirname, '../modules/letter/index.vue')
    },
    {
      path: '/application-materials/reco-letters/submit/:projectId/:userId/:letterId',
      component: resolve(__dirname, '../modules/letter/index.vue')
    },
    {
      path: '/preview',
      props: { isManager: true },
      component: resolve(__dirname, '../modules/my/application/preview.vue')
    },
    {
      path: '/complete',
      component: resolve(__dirname, '../modules/my/application/complete.vue')
    }
  )
}
