import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '数字领导力企业家学者DBA',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { hid: 'viewport', name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { name: 'keywords', content: '加州浸会大学,工商管理博士,DBA,国际留学,美国留学,博士留学,留学' },
      {
        name: 'description',
        content: '权威数字经济专业课程融合国际名校工商管理博士学位，培养数字经济时代下的企业家前瞻力和领导力。'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: ['@/plugins/vant', '@/plugins/i18n', '@/plugins/router', '@/plugins/axios', '@/plugins/element-ui'],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
